'    ***************************************************************************
'    *                         Picbasic Web Server                             *
'    ***************************************************************************
'    * par David REY le 24/06/2005               http://www.RDElectronique.com *
'    ***************************************************************************
'    * serveur web autonome capable de gnrer une page html prsentant        *
'    *  l'internaute l'tat de 4 entres analogiques, 4 entres logiques,     *
'    * 4 sorties logiques et le texte inscrit sur l'cran LCD                  *
'    * L'internaute a la possibilit de modifier l'tat logique des 4 sorties  *
'    * et d'inscrire le texte de son choix sur l'cran LCD                     *
'    ***************************************************************************
'    * Exemple structure variable tableau GET (modif sorties et cran LCD)     *
'    * GET /?O=xxxx&T=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx                         *
'    * O = Etat des sorties logiques (4 caractres 0 ou 1 : O0, O1, O2, O3)    *
'    * T = texte  crire sur l'cran LCD (32 caractres)                      *
'    * La page html prsentant les diffrentes donnes                         *
'    * est mmorise dans une eeprom IC                                       *
'    * Variables utilisables dans la page html :                               *
'    *  $A0,$A1,$A2,$A3 -> entres analogiques                                 *
'    *  $I0,$I1,$I2,$I3 -> entres logiques                                    *
'    *  $O0,$O0,$O0,$O0 -> sorties logiques                                    *
'    *  $T0             -> texte sur cran LCD                                 *
'    *  $CP             -> compteur de connexions depuis dernier RESET         *
'    ***************************************************************************


'    ***************************************************************************
'    DECLARATION DES CONSTANTES
'    ***************************************************************************
     const BYTE k_array=(0,'A','I','O','T','C')               'Liste des variables

     Const CL_MSB_Adr = &H0FFE                                'Avant dernier emplacement mmoire
     Const CL_LSB_Adr = &H0FFF                                'Dernier emplacement mmoire

     Const BDS = 50                                           'Vitesse de transmission (103=9600bds/50=19200bds)

     Const RXD = 8                                            'Broche utilise pour rception srie=I/O8
     Const TXD = 9                                            'Broche utilise pour mission srie=I/O9
                                                     
     Const SDA    = 10                                        'Broche donne I2C=I/O10
     Const SCL    = 11                                        'Broche horloge I2C=I/O11
     Const CTRL_R = &b10100001                                'Octet de contrle lecture
     Const CTRL_W = &b10100000                                'Octet de controle ecriture

     Const O0 = 12                                            'Sortie O0=I/O12
     Const O1 = 13                                            'Sortie O1=I/O13
     Const O2 = 14                                            'Sortie O2=I/O14
     Const O3 = 15                                            'Sortie O3=I/O15


'    ***************************************************************************
'    DECLARATION DES VARIABLES
'    ***************************************************************************
     DIM Adr   AS INTEGER                                     'Pointeur Adressage eeprom
     DIM V     AS INTEGER                                     'Valeur analogique
     DIM u     AS INTEGER                                     'Unit valeur analogique
     DIM d     AS INTEGER                                     'Dizaine valeur analogique
     DIM c     AS INTEGER                                     'Dixime valeur analogique
     DIM CL    AS INTEGER                                     'Content-Length
     DIM i     AS BYTE                                        'Divers
     DIM j     AS BYTE                                        'Divers
     DIM k     AS BYTE                                        'Divers
     DIM l     AS BYTE                                        'Divers
     DIM pos_T AS BYTE                                        'Position du texte LCD
     DIM Cpt   AS INTEGER                                     'Compteur de connexion

     DIM GET(50) AS BYTE                                      'Requte HTTP



'   ****************************************************************************
'   PROGRAMME PRINCIPAL
'   ****************************************************************************


'    INITIALISATIONS
'    ===========================================================================

     Cpt=0                                                    'Initialisation du compteur de connexions

INIT:

'    Initialisation des sorties ------------------------------------------------
     OUT O0,0                                                 'RAZ O0
     OUT O1,0                                                 'RAZ O1
     OUT O2,1                                                 'RAZ O2
     OUT O3,0                                                 'RAZ O3

'    Initialisation de l'afficheur LCD -----------------------------------------
     SET PICBUS HIGH                                          'PICBUS  19200bds
     LCDINIT                                                  'Initialisation LCD
     CLS                                                      'Efface LCD
     LOCATE 0,0 : PRINT "PB-3B WEB SERVER"                    'Message d'accueil Ligne 1
     LOCATE 0,1 : PRINT ""                                    'Message d'accueil Ligne 2

'    Calcul du Content-Length --------------------------------------------------
     CL=EEREAD(CL_MSB_Adr)                                    'Lecture MSB CL
     CL=CL*256                                                'Calcul CL
     i=EEREAD(CL_LSB_Adr)                                     'lecture LSB CL
     CL=CL+i                                                  'Calcul CL



'    MISE A JOUR DES SORTIES DE LA CARTE ET DE L'ECRAN LCD
'    ===========================================================================

DEBUT:

    'Attente connexion client http ---------------------------------------------
    SERIN RXD,BDS,0,1000,DEBUT,[UNTIL(13),GET(0)~49]          'Enregistrement des caractres reus dans la variable GET
                                                              'tant que caractre <> retour chariot (=13)

    'Redirection vers sous programme de programmation eeprom -------------------
    IF GET(0)="P" THEN                                        'Si 3 premiers caractres = "PRG"
      IF GET(1)="R" AND GET(2)="G" THEN GOTO PRG              'enregistre les caractres suivants dans l'eeprom (page HTML)
    END IF                                                    '

    'Incrmentation du compteur de connexions ----------------------------------
    Cpt=Cpt+1

    SEROUT TXD,BDS,0,0,["HTTP/1.0 200 OK",13,10]              'Accus de rception requte accomplie correctement

    'Lecture des donnes contenues dans l'adresse html --------------------------
    j=0                                                       '

    FOR i=0 TO 49                                             'Lecture variable tableau GET
      IF GET(i)="?" THEN j=i+3                                'Si "?" dtect => mmorisation dans j position dbut texte
    NEXT i


    IF j>0 THEN                                               'Si j>0

      'Mise  jour des sorties -------------------------------------------------
      IF GET(j)="1" THEN OUT O0,1 ELSE OUT O0,0               'mise  jour sortie O0
      j=j+1                                                   '
      IF GET(j)="1" THEN OUT O1,1 ELSE OUT O1,0               'mise  jour sortie O1
      j=j+1                                                   '
      IF GET(j)="1" THEN OUT O2,1 ELSE OUT O2,0               'mise  jour sortie O2
      j=j+1                                                   '
      IF GET(j)="1" THEN OUT O3,1 ELSE OUT O3,0               'mise  jour sortie O3

      'Affichage du texte sur l'cran LCD --------------------------------------
      j=j+4                                                   'Position dbut texte
      pos_T=j                                                 'Mmorisation position
      k=j+32                                                  'Position fin du texte
      LOCATE 0,0                                              'Position curseur
      l=j+16                                                  '
      CLS                                                     '
      FOR i=j TO k                                            '
       IF GET(i)="+" THEN GET(i)=32                           'Remplace le + par un espace
       IF i=l THEN LOCATE 0,1                                 'Passage 2me ligne afficheur
       PRINT GET(i)                                           'Affichage caractre sur LCD
      NEXT i                                                  '
                                                              '
    END IF                                                    '



'   ENVOI DE LA PAGE HTML AU CLIENT HTTP
'   ============================================================================

    'Envoi de l'entte http ----------------------------------------------------
    SEROUT TXD,BDS,0,0,["Content-Type: text/html",13,10]      'Type de contenu : html=text/html (si wap=text/vnd.wap.wml)
    SEROUT TXD,BDS,0,0,["Content-Length: ",DEC(CL),13,10]     'Longueur du corps de la rponse
    SEROUT TXD,BDS,0,0,[13,10]                                'Ligne vierge

    'Envoi du code html --------------------------------------------------------
    GOSUB I2C_START                                           'Condition de START
    SHIFTOUT SCL,SDA,2,CTRL_W,8                               'Octet de controle ECRITURE
    SHIFTOUT SCL,SDA,2,0,8                                    'Adresse du 1er octet  lire (MSByte)
    SHIFTOUT SCL,SDA,2,0,8                                    'Adresse du 1er octet  lire (LSByte)
    GOSUB I2C_START                                           'Condition de START
    SHIFTOUT SCL,SDA,2,CTRL_R,8                               'Octet de controle LECTURE

SUITE_RAZ:

    i=0:j=0:k=0                                               'initialisation des variables

SUITE:

    j=SHIFTIN(SCL,SDA,1,8)                                    'Lecture de la donne
    IF j=26 THEN GOTO I2C_NOACK ELSE GOSUB I2C_ACK            'Envoi acknowledge

    ON k GOTO 100,1,2,3,4,5                                   'branche sur une ligne en fonction de la valeur de k (ex: si k=1 branche sur la ligne 1)

    'LECTURE ANALOGIQUE --------------------------------------------------------
1   j=j-48
    V=ADIN(j)                                                 'Lecture donne analogique
    GOSUB CONV                                                'SP conversion mesure
    SEROUT TXD,BDS,0,0,[u,",",d,c]                            'Envoi valeur mesure u,dc
    GOTO SUITE_RAZ                                            '

    'LECTURE NUMERIQUE DES ENTREES ---------------------------------------------
2   j=j-48                                                    'ASCII -> DECIMAL
    j=j+17                                                    'n sortie concerne
    j=IN(j)                                                   'Lecture tat sortie
    j=j+48                                                    'DECIMAL -> ASCII
    SEROUT TXD,BDS,0,0,[j]                                    'Envoi tat entre
    GOTO SUITE_RAZ                                            'Branche sur l'tiquette SUITE_RAZ

    'LECTURE NUMERIQUE DES SORTIES ---------------------------------------------
3   j=j-48                                                    'ASCII -> DECIMAL
    j=j+12                                                    'n sortie concerne
    j=OUTSTAT(j)                                              'Lecture tat entre
    j=j+48                                                    'DECIMAL -> ASCII
    SEROUT TXD,BDS,0,0,[j]                                    'Envoi tat entre
    GOTO SUITE_RAZ                                            'Branche sur l'tiquette SUITE_RAZ

    'ECRAN LCD -----------------------------------------------------------------
4   IF pos_T>0 THEN                                           'Si texte modifi depuis RAZ serveur
     l=pos_T+32                                               'Borne sup (32 caractres)
     FOR j=pos_T TO l                                         '
       SEROUT TXD,BDS,0,0,[GET(j)]                            'Envoi des 32 caractres
     NEXT j                                                   '
    ELSE                                                      '
      SEROUT TXD,BDS,0,0,["PB-3B WEB SERVER                "] 'Texte par dfaut
    END IF                                                    '
    GOTO SUITE_RAZ                                            'Branche sur l'tiquette SUITE_RAZ

    'COMPTEUR DE CONNEXIONS ----------------------------------------------------
5   IF j="P" THEN SEROUT TXD,BDS,0,0,[DEC(Cpt)]               'Envoi donne compteur
    GOTO SUITE_RAZ                                            'Branche sur l'tiquette SUITE_RAZ


100                                                           '
    IF i="$" THEN                                             'si caractre n-1 = $
     FOR k=1 TO 5                                             '
      IF k_array(k)=j THEN GOTO SUITE                         '
     NEXT k                                                   '
    END IF                                                    '
    
    IF j<>"$" THEN SEROUT TXD,BDS,0,0,[j]                     'Envoi resultat sur port srie

    i=j                                                       'Caractre n-1 = caractre n

    GOTO SUITE                                                'Branche sur tiquette SUITE => Lecture donne suivante



'   PROGRAMMATION DE L'EEPROM (fichier HTML envoy sur la SCI)
'   ============================================================================

PRG:
    LOCATE 0,0 : PRINT "HTML -> EEPROM  "                     'Affichage commentaire LCD

    'Programmation de l'eeprom srie -------------------------------------------
    Adr=0                                                     'Initialisation pointeur adresse eeprom
PAT:SERIN RXD,BDS,0,1000,PAT,[j]                              'Lecture d'un caractre sur SCI
    GOSUB I2C_WRITE_BYTE                                      'Ecriture du caractre dans l'eeprom
    LOCATE 0,1 : PRINT "Octets : ",DEC(Adr)                   'Affichage sur l'cran LCD le nombre d'octets programms
    SEROUT TXD,BDS,0,0,[j]                                    'Renvoi du caractre sur SCI pour confirmation
    IF j<>26 THEN GOTO PAT                                    '26 signale la fin du fichier HTML

    'Mise  jour du content-length en mmoire ----------------------------------
    Adr=Adr+29                                                'Une fois les variables remplaces par leur valeur il faudra ajouter 29 octets pour compenser
    i=Adr/256                                                 'Calcul du MSB
    EEWRITE CL_MSB_Adr,i                                      'Mmorisation en eeprom
    i=Adr                                                     'Calcul du LSB
    EEWRITE CL_LSB_Adr,i                                      'Mmorisation en eeprom

    DELAY 2500                                                'Tempo 2,5s

    GOTO INIT                                                 'Branche sur l'tiquette INIT




'   ****************************************************************************
'   SOUS-PROGRAMMES
'   ****************************************************************************

'   I2C : ECRITURE 1 octet
'   ============================================================================
I2C_WRITE_BYTE:
    GOSUB I2C_START                                           'Condition de START
    SHIFTOUT SCL,SDA,2,CTRL_W,8                               'Octet de contrle LECTURE
    i=Adr/256                                                 'Octet de poids fort
    SHIFTOUT SCL,SDA,2,i,8                                    'Adresse dbut criture (MSByte)
    i=Adr                                                     'Octet de poids faible
    SHIFTOUT SCL,SDA,2,i,8                                    'Adresse dbut criture (LSByte)
    SHIFTOUT SCL,SDA,2,j,8                                    'Ecriture en eeprom de j
    Adr=Adr+1                                                 'Incrementation pointeur adresse
    DELAY 5                                                   'Tempo 5ms
    GOSUB I2C_STOP                                            'Condition de STOP
    DELAY 5                                                   'Tempo 5ms
    RETURN                                                    '


'   I2C : START
'   ============================================================================
I2C_START:
    OUT SCL,0                                                 'SCL=0
    OUT SDA,1                                                 'SDA=1
    OUT SCL,1                                                 'SCL=1
    OUT SDA,0                                                 'SDA=0
    OUT SCL,0                                                 'SCL=0
    RETURN


'   I2C : STOP
'   ============================================================================
I2C_STOP:
    OUT SCL,0                                                 'SCL=0
    OUT SDA,0                                                 'SDA=0
    OUT SCL,1                                                 'SCL=1
    OUT SDA,1                                                 'SDA=1
    OUT SCL,0                                                 'SCL=0
    RETURN


'   I2C : ACKNOWLEDGE (mis par le PicBasic)
'   ============================================================================
I2C_ACK:
    OUT SCL,0                                                 'SCL=0
    OUT SDA,0                                                 'SDA=0
    OUT SCL,1                                                 'SCL=1
    OUT SCL,0                                                 'SCL=0
    RETURN    


'   I2C : NO ACKNOWLEDGE (mis par le PicBasic)
'   ============================================================================
I2C_NOACK:
    OUT SCL,0                                                 'SCL=0
    OUT SCL,1                                                 'SCL=1
    OUT SCL,0                                                 'SCL=0
    GOSUB I2C_STOP                                            'Condition de STOP
    GOTO DEBUT                                                'Retour au dbut du programme


'   Conversion DECIMAL -> TENSION -> ASCII : x,xx
'   ============================================================================
CONV:
    V=V/4                                                     'Rsolution 10 bits -> 8 bits
    V=(100*V)/51                                              'Calcul tension nombre entier
    u=V/100                                                   'Calcul unit
    c=100*u                                                   '
    d=(V-c)/10                                                'Calcul dixime
    c=c+(10*d)                                                '
    c=V-c                                                     'Calcul centime
    u=u+48                                                    'Unit    -> CODE ASCII
    d=d+48                                                    'Dixime  -> CODE ASCII
    c=c+48                                                    'Centime -> CODE ASCII
    RETURN                                                    '

'*** FIN DU PROGRAMME **********************************************************